/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBTabela;
import fme.CFLib;
import fme.CHTabColModel;
import fme.CHValid_Grp;
import fme.CHValid_Msg;
import fme.CTabelas;
import fme.Frame_Proj_2;
import fme.GroupableTableHeaderUI;
import fme.TabError;
import fme.TabelaListener;
import fme.TableKeyListener;
import fme._lib;
import fme.fmeFrame;
import javax.swing.JComboBox;

class CBTabela_Resultados
extends CBTabela {
    Frame_Proj_2 P;
    JComboBox mercados;

    @Override
    public String getPagina() {
        return "Proj_2";
    }

    CBTabela_Resultados() {
        this.tag = "Resultados";
        this.P = (Frame_Proj_2)fmeFrame.Paginas.getPage("Proj_2");
        if (this.P == null) {
            return;
        }
        this.started = true;
        this.cols = new CHTabColModel[11];
        this.cols[0] = new CHTabColModel("n_ordem", "N\u00ba", true, false, true, null);
        this.cols[1] = new CHTabColModel("mercado", "Mercado Alvo (id)", true, true, false, null);
        this.cols[2] = new CHTabColModel("mercado_d", "Mercado Alvo", false, true, true, null);
        this.cols[3] = new CHTabColModel("tipo_prod", "Tipo de Produto (id)", true, true, false, null);
        this.cols[4] = new CHTabColModel("tipo_prod_d", "Tipo de Produto", false, true, true, null);
        this.cols[5] = new CHTabColModel("vol_actual", "Situa\u00e7\u00e3o Atual (Volume)", true, true, true, CFLib.VLD_VALOR_0);
        this.cols[6] = new CHTabColModel("valor_actual", "Situa\u00e7\u00e3o Atual (Valor)", true, true, true, CFLib.VLD_VALOR_0);
        this.cols[7] = new CHTabColModel("preco_actual", "Situa\u00e7\u00e3o Atual (Pre\u00e7o M\u00e9dio)", true, false, true, CFLib.VLD_VALOR);
        this.cols[8] = new CHTabColModel("vol_final", "Situa\u00e7\u00e3o Final (Volume)", true, true, true, CFLib.VLD_VALOR);
        this.cols[9] = new CHTabColModel("valor_final", "Situa\u00e7\u00e3o Final (Valor)", true, true, true, CFLib.VLD_VALOR);
        this.cols[10] = new CHTabColModel("preco_final", "Situa\u00e7\u00e3o Final (Pre\u00e7o M\u00e9dio)", true, false, true, CFLib.VLD_VALOR);
        this.init_dados(10);
        this.init_handler(this.P.getJTable_Resultados());
        this.P.getJTable_Resultados().addKeyListener(new TableKeyListener(this));
        this.handler.width = this.P.getJScrollPane_Resultados().getWidth() - 2;
        this.ui = new GroupableTableHeaderUI();
        this.ui.setH(2, this.P.getJTable_Resultados());
        this.ui.add_col(0, 0, 1, 2, "N\u00ba");
        this.ui.add_col(1, 0, 1, 2, "Mercado Alvo");
        this.ui.add_col(2, 0, 1, 2, "<html>Tipo de<br>Produto</html>");
        this.ui.add_col(3, 0, 3, 1, "Situa\u00e7\u00e3o Atual");
        this.ui.add_col(3, 1, 1, 1, "Volume (litros)");
        this.ui.add_col(4, 1, 1, 1, "Valor (\u20ac)");
        this.ui.add_col(5, 1, 1, 1, "Pre\u00e7o M\u00e9dio (\u20ac/litro)");
        this.ui.add_col(6, 0, 3, 1, "Situa\u00e7\u00e3o Final");
        this.ui.add_col(6, 1, 1, 1, "Volume (litros)");
        this.ui.add_col(7, 1, 1, 1, "Valor (\u20ac)");
        this.ui.add_col(8, 1, 1, 1, "Pre\u00e7o M\u00e9dio (\u20ac/litro)");
        this.P.getJTable_Resultados().getTableHeader().setUI(this.ui);
        this.handler.set_col(0, 0.05, "C");
        this.mercados = this.handler.set_col_comboS(2, 0.18, null, CTabelas.Mercados, 1, 200);
        this.handler.set_col_comboS(4, 0.0775, "C", CTabelas.TipoProd, 1, 0);
        this.handler.set_col_text(5, 0.11, "R");
        this.handler.set_col_text(6, 0.11, "R");
        this.handler.set_col_text(7, 0.12, "R");
        this.handler.set_col_text(8, 0.11, "R");
        this.handler.set_col_text(9, 0.11, "R");
        this.handler.set_col_text(10, 0.12, "R");
        CTabelas.Mercados.registerTabelaListener(new TabelaListener(this, this.mercados));
    }

    @Override
    void on_update(String colname, int nRow, String v) {
        this.numerar(0);
        if (colname.equals("mercado_d")) {
            String mercado = "";
            if (v.length() > 0) {
                mercado = CTabelas.Mercados.lookup(1, v, 0);
            }
            this.setColValue("mercado", nRow, mercado);
        }
        if (colname.equals("mercado")) {
            String mercado_d = "";
            if (v.length() > 0) {
                mercado_d = CTabelas.Mercados.lookup(0, v, 1);
            }
            this.setColValue("mercado_d", nRow, mercado_d);
        }
        if (colname.equals("tipo_prod_d")) {
            String tipo_prod = "";
            if (v.length() > 0) {
                tipo_prod = CTabelas.TipoProd.lookup(1, v, 0);
            }
            this.setColValue("tipo_prod", nRow, tipo_prod);
        }
        if (colname.equals("tipo_prod")) {
            String tipo_prod_d = "";
            if (v.length() > 0) {
                tipo_prod_d = CTabelas.TipoProd.lookup(0, v, 1);
            }
            this.setColValue("tipo_prod_d", nRow, tipo_prod_d);
        }
        if (!colname.startsWith("valor_") && !colname.startsWith("vol_")) {
            return;
        }
        String suf = colname.substring(colname.indexOf("_"));
        double valor = _lib.to_double(this.getColValue("valor" + suf, nRow));
        double vol = _lib.to_double(this.getColValue("vol" + suf, nRow));
        if (vol != 0.0) {
            double preco = _lib.round(valor / vol);
            this.setColValue("preco" + suf, nRow, preco == 0.0 ? "" : String.valueOf(preco));
        } else {
            this.setColValue("preco" + suf, nRow, "");
        }
    }

    @Override
    boolean on_del_row() {
        boolean res = this.on_del_row(false);
        this.numerar(0);
        return res;
    }

    @Override
    String on_xml(String tag, int row, String v) {
        String s = "";
        if (tag.equals("mercado")) {
            s = String.valueOf(s) + _lib.xml_encode("mercado_d", this.getColValue("mercado_d", row));
        }
        if (tag.equals("tipo_prod")) {
            s = String.valueOf(s) + _lib.xml_encode("tipo_prod_d", this.getColValue("tipo_prod_d", row));
        }
        return s;
    }

    CHValid_Grp validar(CHValid_Grp err_list) {
        if (err_list == null) {
            err_list = new CHValid_Grp(this, "Resultados esperados por mercado");
        }
        if (!this.isEmpty()) {
            char val;
            StringBuffer mask = new StringBuffer("--R--------");
            boolean divulgacao = CBData.ActivSector.getCountIf("actividade", "13") > 0;
            boolean ent_certif = CBData.Promotor.isCertificadora();
            char c = divulgacao ? (char)'R' : (val = ent_certif ? (char)'-' : 'R');
            char vol = divulgacao ? (char)'-' : (ent_certif ? (char)'-' : 'R');
            mask.setCharAt(this.getColIndex("valor_actual"), val);
            mask.setCharAt(this.getColIndex("valor_final"), val);
            mask.setCharAt(this.getColIndex("vol_actual"), vol);
            mask.setCharAt(this.getColIndex("vol_final"), vol);
            int j = 0;
            while (j < this.dados.size()) {
                if (!this.isRowEmpty(j)) {
                    TabError[] e = this.isIncompletAll(j, mask.toString());
                    int ii = 0;
                    while (e != null && ii < e.length) {
                        err_list.add_msg(new CHValid_Msg(e[ii]));
                        ++ii;
                    }
                    if (ent_certif && !divulgacao) {
                        int v1;
                        int v2;
                        String[] row = (String[])this.dados.get(j);
                        if (row[v2 = this.getColIndex("valor_actual")].isEmpty() && row[v1 = this.getColIndex("vol_actual")].isEmpty()) {
                            err_list.add_msg(new CHValid_Msg("Linha " + (j + 1) + " incompleta: " + this.cols[v1].col_name2 + " e / ou " + this.cols[v2].col_name2 + " - %o", j, v1));
                        }
                        if (row[v2 = this.getColIndex("valor_final")].isEmpty() && row[v1 = this.getColIndex("vol_final")].isEmpty()) {
                            err_list.add_msg(new CHValid_Msg("Linha " + (j + 1) + " incompleta: " + this.cols[v1].col_name2 + " e / ou " + this.cols[v2].col_name2 + " - %o", j, v1));
                        }
                    }
                    String tipo = this.getColValue("tipo_prod", j);
                    String pais = this.getColValue("mercado", j);
                    if (tipo.length() > 0 && pais.length() > 0) {
                        int i = 0;
                        while (i < j) {
                            String tipo2 = this.getColValue("tipo_prod", i);
                            String pais2 = this.getColValue("mercado", i);
                            if (tipo2.equals(tipo) && pais2.equals(pais)) {
                                err_list.add_msg(new CHValid_Msg("Linha " + (j + 1) + " - Mercado Alvo / Tipo de Produto repetido", j, this.getColIndex("mercado_d")));
                                break;
                            }
                            ++i;
                        }
                    }
                }
                ++j;
            }
        }
        int i = 0;
        while (i < CTabelas.Mercados.data_table.size()) {
            String cod = ((String[])CTabelas.Mercados.data_table.elementAt(i))[0];
            String mercado = ((String[])CTabelas.Mercados.data_table.elementAt(i))[1];
            if (cod != null && !cod.equals("")) {
                boolean existe = false;
                int j = 0;
                while (j < this.dados.size()) {
                    if (!this.isRowEmpty(j) && this.getColValue("mercado", j).equals(cod)) {
                        existe = true;
                        break;
                    }
                    ++j;
                }
                if (!existe) {
                    err_list.add_msg(new CHValid_Msg("P.f. indique os resultados esperados para o mercado " + mercado));
                }
            }
            ++i;
        }
        return err_list;
    }
}

